import salome, SMESH
import smesh
import StdMeshers

# start the mesher here
Mshell = smesh.Mesh(Face1)
CompositeSegment1D   = Mshell.Segment(algo=smesh.COMPOSITE)
AutomaticLength1     = CompositeSegment1D.AutomaticLength(1.0)
Quadratic_Mesh1      = CompositeSegment1D.QuadraticMesh()
Quadrangle2D         = Mshell.Quadrangle()
QuadranglePreference = Quadrangle2D.QuadranglePreference()
isDone               = Mshell.Compute()

smesh.SetName(Mshell.GetMesh(),'Mshell')

# add groups in the mesh for boundary conditions, loads, etc
Linex1 = Mshell.Group(Linex1)
Liney1 = Mshell.Group(Liney1)
Linex0 = Mshell.Group(Linex0)
Liney0 = Mshell.Group(Liney0)
shell  = Mshell.Group(shell)

smesh.SetName(CompositeSegment1D.GetAlgorithm(), 'CompositeSegment_1D')
smesh.SetName(Quadrangle2D.GetAlgorithm(), 'Quadrangle_2D')
smesh.SetName(QuadranglePreference, 'QuadranglePreference')
smesh.SetName(shell, 'shell')
smesh.SetName(Linex1, 'Linex1')
smesh.SetName(Liney1, 'Liney1')
smesh.SetName(Linex0, 'Linex0')
smesh.SetName(Liney0, 'Liney0')
