import geompy
import math

import salome, SMESH
import smesh
import StdMeshers


# define four corner points
X1 = 1.0
Y1 = 1.0
p00 = geompy.MakeVertex(0.0, 0.0, 0.0)
p10 = geompy.MakeVertex(X1,  0.0, 0.0)
p11 = geompy.MakeVertex(X1,  Y1,  0.0)
p01 = geompy.MakeVertex(0.0, Y1,  0.0)

# define lines between corner points
Ly0 = geompy.MakeLineTwoPnt(p00, p10)
Lx1 = geompy.MakeLineTwoPnt(p10, p11)
Ly1 = geompy.MakeLineTwoPnt(p11, p01)
Lx0 = geompy.MakeLineTwoPnt(p01, p00)

#define face between lines
Face1 = geompy.MakeFaceWires([Ly0, Lx1, Ly1, Lx0], 1)

#  create a group to be meshed by shell elements in Code Aster
shell = geompy.CreateGroup(Face1, geompy.ShapeType["FACE"])
geompy.UnionIDs(shell, [1])
Face1 = geompy.GetMainShape(shell)

# create a group for boundary conditions in CA
Linex1 = geompy.CreateGroup(Face1, geompy.ShapeType["EDGE"])
geompy.UnionIDs(Linex1, [10])
Face1 = geompy.GetMainShape(Linex1)
Liney1 = geompy.CreateGroup(Face1, geompy.ShapeType["EDGE"])
geompy.UnionIDs(Liney1, [3])
Face1 = geompy.GetMainShape(Liney1)
Linex0 = geompy.CreateGroup(Face1, geompy.ShapeType["EDGE"])
geompy.UnionIDs(Linex0, [6])
Face1 = geompy.GetMainShape(Linex0)
Liney0 = geompy.CreateGroup(Face1, geompy.ShapeType["EDGE"])
geompy.UnionIDs(Liney0, [8])
Face1 = geompy.GetMainShape(Liney0)


# add all the components to the study
geompy.addToStudy( p00, "p00" )
geompy.addToStudy( p10, "p10" )
geompy.addToStudy( p11, "p11" )
geompy.addToStudy( p01, "p01" )
geompy.addToStudy( Ly0, "Ly0" )
geompy.addToStudy( Lx1, "Lx1" )
geompy.addToStudy( Ly1, "Ly1" )
geompy.addToStudy( Lx0, "Lx0" )
geompy.addToStudy( Face1, "Face1" )

# add the groups to the study
# Linexi are same components as Lzi in main geometry
geompy.addToStudyInFather( Face1, shell, "shell" )
geompy.addToStudyInFather( Face1, Linex1, "Linex1" )
geompy.addToStudyInFather( Face1, Liney1, "Liney1" )
geompy.addToStudyInFather( Face1, Linex0, "Linex0" )
geompy.addToStudyInFather( Face1, Liney0, "Liney0" )

# start the mesher here
Mshell = smesh.Mesh(Face1)
CompositeSegment1D   = Mshell.Segment(algo=smesh.COMPOSITE)
AutomaticLength1     = CompositeSegment1D.AutomaticLength(1.0)
Quadratic_Mesh1      = CompositeSegment1D.QuadraticMesh()
Quadrangle2D         = Mshell.Quadrangle()
QuadranglePreference = Quadrangle2D.QuadranglePreference()
isDone               = Mshell.Compute()

smesh.SetName(Mshell.GetMesh(),'Mshell')

# add groups in the mesh for boundary conditions, loads, etc
Linex1 = Mshell.Group(Linex1)
Liney1 = Mshell.Group(Liney1)
Linex0 = Mshell.Group(Linex0)
Liney0 = Mshell.Group(Liney0)
shell  = Mshell.Group(shell)

smesh.SetName(CompositeSegment1D.GetAlgorithm(), 'CompositeSegment_1D')
smesh.SetName(Quadrangle2D.GetAlgorithm(), 'Quadrangle_2D')
smesh.SetName(QuadranglePreference, 'QuadranglePreference')
smesh.SetName(shell, 'shell')
smesh.SetName(Linex1, 'Linex1')
smesh.SetName(Liney1, 'Liney1')
smesh.SetName(Linex0, 'Linex0')
smesh.SetName(Liney0, 'Liney0')
