import GEOM
import geompy
import math
import SALOMEDS


import salome, SMESH, SALOMEDS
import smesh
import string, os, sys, re
import NETGENPlugin
#sys.path.insert( 0, os.path.dirname(__file__) )
#exec("from "+re.sub("SMESH$","GEOM",__name__)+" import *")



p1_1 = geompy.MakeVertex(0, 0, 0)
p1_2 = geompy.MakeVertex(1, 23, 2)

block1 = geompy.MakeBoxTwoPnt(p1_1, p1_2)


Afix = geompy.CreateGroup(block1, geompy.ShapeType["FACE"])
geompy.UnionIDs(Afix, [23])
Apres = geompy.CreateGroup(block1, geompy.ShapeType["FACE"])
geompy.UnionIDs(Apres, [27])


geompy.addToStudy( p1_1, "p1_1" )
geompy.addToStudy( p1_2, "p1_2" )
geompy.addToStudy( block1, "block1" )

geompy.addToStudyInFather( block1, Afix, "Afix" )
geompy.addToStudyInFather( block1, Apres, "Apres" )



### mesh
NETGEN_3D_Parameters = smesh.CreateHypothesis('NETGEN_Parameters', 'NETGENEngine')
NETGEN_3D_Parameters.SetMaxSize( 10.000 )
NETGEN_3D_Parameters.SetSecondOrder( 1 )
NETGEN_3D_Parameters.SetOptimize( 1 )
NETGEN_3D_Parameters.SetFineness( 1 )
mbeam = smesh.Mesh(block1)
Netgen_1D_2D_3D = mbeam.Tetrahedron(algo=smesh.FULL_NETGEN)
NETGEN_3D_Parameters = Netgen_1D_2D_3D.Parameters()
isDone  = mbeam.Compute()
Afix  = mbeam.Group(Afix)
Apres = mbeam.Group(Apres)

## set object names
smesh.SetName(NETGEN_3D_Parameters, 'NETGEN 3D Parameters')
smesh.SetName(mbeam.GetMesh(), 'mbeam')
smesh.SetName(Netgen_1D_2D_3D.GetAlgorithm(), 'Netgen 1D-2D-3D')
smesh.SetName(NETGEN_3D_Parameters, 'NETGEN 3D Parameters')
smesh.SetName(Afix, 'Afix')
smesh.SetName(Apres, 'Apres')

if salome.sg.hasDesktop():
		salome.sg.updateObjBrowser(0)
