import GEOM
import geompy
import math
import SALOMEDS


import salome, SMESH, SALOMEDS
import smesh
import string, os, sys, re
import NETGENPlugin
#sys.path.insert( 0, os.path.dirname(__file__) )
#exec("from "+re.sub("SMESH$","GEOM",__name__)+" import *")



p1_1 = geompy.MakeVertex(0.0, 0.0, 0.0)
p1_2 = geompy.MakeVertex(5.0, 6.0, 7.0)
p2_1 = geompy.MakeVertex(0.0, 1.2, 0.0)
p2_2 = geompy.MakeVertex(5.0, 6.0, 6.3)

pc1_1 = geompy.MakeVertex(2.5, 0.0, 2.9)
pc1_2 = geompy.MakeVertex(1.5, 0.0, 4.7)
pc1_3 = geompy.MakeVertex(3.5, 0.0, 4.7)
pc2_1 = geompy.MakeVertex(1.5, 3.5, 7)
pc2_2 = geompy.MakeVertex(3.5, 3.5, 7)

vy = geompy.MakeVectorDXDYDZ(0, 1, 0)
vz = geompy.MakeVectorDXDYDZ(0, 0, -1)

block1 = geompy.MakeBoxTwoPnt(p1_1, p1_2)
block2 = geompy.MakeBoxTwoPnt(p2_1, p2_2)
Lshapeo = geompy.MakeCut(block1, block2)

cylinder1a = geompy.MakeCylinder(pc1_1, vy, 0.9, 3)
cylinder1b = geompy.MakeCylinder(pc1_2, vy, 0.9, 3)
cylinder1c = geompy.MakeCylinder(pc1_3, vy, 0.9, 3)
cylinder2a = geompy.MakeCylinder(pc2_1, vz, 0.8, 3)
cylinder2b = geompy.MakeCylinder(pc2_2, vz, 0.8, 3)

Lshape1a = geompy.MakeCut(Lshapeo, cylinder1a)
Lshape1b = geompy.MakeCut(Lshape1a, cylinder1b)
Lshape1c = geompy.MakeCut(Lshape1b, cylinder1c)
Lshape2a = geompy.MakeCut(Lshape1c, cylinder2a)
Lshape2b = geompy.MakeCut(Lshape2a, cylinder2b)


Lshapec = geompy.MakeFillet(Lshape2b, 0.5, geompy.ShapeType["EDGE"], [43])
Lshape = geompy.MakeFillet(Lshapec, 1.2, geompy.ShapeType["EDGE"], [69])

Afix = geompy.CreateGroup(Lshape, geompy.ShapeType["FACE"])
geompy.UnionIDs(Afix, [74])
Apres = geompy.CreateGroup(Lshape, geompy.ShapeType["FACE"])
geompy.UnionIDs(Apres, [40])


Rin = geompy.CreateGroup(Lshape, geompy.ShapeType["FACE"])
geompy.UnionIDs(Rin, [79])
Rout = geompy.CreateGroup(Lshape, geompy.ShapeType["FACE"])
geompy.UnionIDs(Rout, [35])



geompy.addToStudy( p1_1, "p1_1" )
geompy.addToStudy( p1_2, "p1_2" )
geompy.addToStudy( p2_1, "p2_1" )
geompy.addToStudy( p2_2, "p2_2" )

geompy.addToStudy( pc1_1, "pc1_1" )
geompy.addToStudy( pc1_2, "pc1_2" )
geompy.addToStudy( pc1_3, "pc1_3" )
geompy.addToStudy( pc2_1, "pc2_1" )
geompy.addToStudy( pc2_2, "pc2_2" )
geompy.addToStudy( vy, "vy" )
geompy.addToStudy( vz, "vz" )


geompy.addToStudy( block1, "block1" )
geompy.addToStudy( block2, "block2" )
geompy.addToStudy( Lshape, "Lshape" )
 

geompy.addToStudyInFather( Lshape, Afix, "Afix" )
geompy.addToStudyInFather( Lshape, Apres, "Apres" )
geompy.addToStudyInFather( Lshape, Rin, "Rin" )
geompy.addToStudyInFather( Lshape, Rout, "Rout" )



### mesh
NETGEN_3D_Parameters = smesh.CreateHypothesis('NETGEN_Parameters', 'NETGENEngine')
NETGEN_3D_Parameters.SetMaxSize( 2.000 )
NETGEN_3D_Parameters.SetSecondOrder( 1 )
NETGEN_3D_Parameters.SetOptimize( 1 )
NETGEN_3D_Parameters.SetFineness( 1 )
mlshape = smesh.Mesh(Lshape)
Netgen_1D_2D_3D = mlshape.Tetrahedron(algo=smesh.FULL_NETGEN)
NETGEN_3D_Parameters = Netgen_1D_2D_3D.Parameters()
isDone  = mlshape.Compute()
Afix  = mlshape.Group(Afix)
Apres = mlshape.Group(Apres)
Rin   = mlshape.Group(Rin)
Rout  = mlshape.Group(Rout)

## set object names
smesh.SetName(NETGEN_3D_Parameters, 'NETGEN 3D Parameters')
smesh.SetName(mlshape.GetMesh(), 'mlshape')
smesh.SetName(Netgen_1D_2D_3D.GetAlgorithm(), 'Netgen 1D-2D-3D')
smesh.SetName(NETGEN_3D_Parameters, 'NETGEN 3D Parameters')
smesh.SetName(Afix, 'Afix')
smesh.SetName(Apres, 'Apres')
smesh.SetName(Rin, 'Rin')
smesh.SetName(Rout, 'Rout')

if salome.sg.hasDesktop():
		salome.sg.updateObjBrowser(0)



