
import Numeric

import geompy
import SALOMEDS
import salome
import smesh

import StdMeshers
import NETGENPlugin

from SMESH import *
from StdMeshers import *


## import GEOM dump file ## 
import string, os, sys, re


zeta = 0.5   
zetam1 = 1-zeta
Bx = 3
By = 8
Bz = 23
block = geompy.MakeBoxDXDYDZ(Bx,By,Bz)


block26 = geompy.GetSubShape(block, [26])
p1star = geompy.MakeVertexOnCurve(block26,zeta)
block30 = geompy.GetSubShape(block, [30])
p2star = geompy.MakeVertexOnCurve(block30,zetam1)

# to be used in the mesher
x1,y1,z1 = geompy.PointCoordinates(p1star)
x2,y2,z2 = geompy.PointCoordinates(p2star)

DZplus = 17.0
DZmin  = -0.1 # create overlap of shell into volume block


p1 = geompy.MakeVertexWithRef(p1star, 0, 0, -DZmin)
p2 = geompy.MakeVertexWithRef(p2star, 0, 0, -DZmin)
p3 = geompy.MakeVertexWithRef(p2star, 0, 0, DZplus)
p4 = geompy.MakeVertexWithRef(p1star, 0, 0, DZplus)

line1 = geompy.MakeLineTwoPnt(p1, p4)
line2 = geompy.MakeLineTwoPnt(p4, p3)
line3 = geompy.MakeLineTwoPnt(p3, p2)
line4 = geompy.MakeLineTwoPnt(p2, p1)
face1 = geompy.MakeFaceWires([line1, line2, line3, line4], 1)


# create groups (Faces) at top  and bottom of block
FBbot = geompy.CreateGroup(block, geompy.ShapeType["FACE"])
geompy.UnionIDs(FBbot, [31])
block = geompy.GetMainShape(FBbot)
FBtop = geompy.CreateGroup(block, geompy.ShapeType["FACE"])
geompy.UnionIDs(FBtop, [33])
block = geompy.GetMainShape(FBtop)


# create groups (edges) at top and bottom of face1
EFbot = geompy.CreateGroup(face1, geompy.ShapeType["EDGE"])
geompy.UnionIDs(EFbot, [6])
face1 = geompy.GetMainShape(EFbot)
EFtop = geompy.CreateGroup(face1, geompy.ShapeType["EDGE"])
geompy.UnionIDs(EFtop, [10])
face1 = geompy.GetMainShape(EFtop)

# create groups (shell and node) on faces face1-2
shell = geompy.CreateGroup(face1, geompy.ShapeType["FACE"])
geompy.UnionIDs(shell, [1])
face1 = geompy.GetMainShape(shell)

# make entities visible
geompy.addToStudy( p1, "p1" )
geompy.addToStudy( p2, "p2" )
geompy.addToStudy( p3, "p3" )
geompy.addToStudy( p4, "p4" )

geompy.addToStudy( line1, "line1" )
geompy.addToStudy( line2, "line2" )
geompy.addToStudy( line3, "line3" )
geompy.addToStudy( line4, "line4" )


# create compounds of constr <-- face1 and blcok
constr = geompy.MakeCompound([face1, block])

# define group on constr
Cline = geompy.CreateGroup(constr, geompy.ShapeType["EDGE"])
geompy.UnionIDs(Cline, [7])
constr = geompy.GetMainShape(Cline)
Ctop = geompy.CreateGroup(constr, geompy.ShapeType["FACE"])
geompy.UnionIDs(Ctop, [44])
constr = geompy.GetMainShape(Ctop)
Cbot = geompy.CreateGroup(constr, geompy.ShapeType["FACE"])
geompy.UnionIDs(Cbot, [42])
constr = geompy.GetMainShape(Cbot)

Nforce = geompy.CreateGroup(constr, geompy.ShapeType["VERTEX"])
geompy.UnionIDs(Nforce, [5, 10])
constr = geompy.GetMainShape(Nforce)


geompy.addToStudy( constr, "constr" )
geompy.addToStudy( face1, "face1" )
geompy.addToStudy( block, "block" )

geompy.addToStudyInFather(constr,block, "block" )
geompy.addToStudyInFather(constr,shell, "shell" )
geompy.addToStudyInFather(constr,FBtop, "FBtop" )
geompy.addToStudyInFather(constr,FBbot, "FBbot" )
geompy.addToStudyInFather(constr,Ctop, "Ctop" )
geompy.addToStudyInFather(constr,Cbot, "Cbot" )
geompy.addToStudyInFather(constr,Cline, "Cline" )
geompy.addToStudyInFather(constr,Nforce, "Nforce" )


### ============
### start mesher
### ============

constr = smesh.Mesh(constr)
NETGEN_3D_Parameters = smesh.CreateHypothesis('NETGEN_Parameters', 'NETGENEngine')
NETGEN_3D_Parameters.SetMaxSize( 0.4 )
NETGEN_3D_Parameters.SetSecondOrder( 1 )
NETGEN_3D_Parameters.SetOptimize( 1 )
NETGEN_3D_Parameters.SetFineness( 3 )
Max_Size3D = smesh.CreateHypothesis('MaxLength')
Max_Size3D.SetLength( 1.0 )
NETGEN_2D_Parameters = smesh.CreateHypothesis('NETGEN_Parameters_2D', 'NETGENEngine')
NETGEN_2D_Parameters.SetMaxSize( 0.4 )
NETGEN_2D_Parameters.SetSecondOrder( 1 )
NETGEN_2D_Parameters.SetOptimize( 1 )
NETGEN_2D_Parameters.SetFineness( 2 )
NETGEN_2D_Parameters.SetQuadAllowed( 0 )
Max_Size2D = smesh.CreateHypothesis('MaxLength')
Max_Size2D.SetLength( 1.0 )
Regular1D = constr.Segment()
Automatic_length = Regular1D.AutomaticLength(0.6)
#Quadratic_Mesh = Regular1D.QuadraticMesh()
MEFISTO_2D = constr.Triangle()
Tetrahedron_Netgen = constr.Tetrahedron(algo=smesh.NETGEN)
isDone = constr.Compute()


###=====================================
### add groups to mesh for loads, bc, materialprops
block = constr.Group(block)
shell = constr.Group(shell)
FBbot = constr.Group(FBbot)
FBtop = constr.Group(FBtop)
Nforce = constr.Group(Nforce)



## set object names
smesh.SetName(constr.GetMesh(), 'constr')
smesh.SetName(NETGEN_3D_Parameters, 'NETGEN 3D Parameters')
smesh.SetName(Max_Size3D, 'Max Size 3D')
smesh.SetName(NETGEN_2D_Parameters, 'NETGEN 2D Parameters')
smesh.SetName(Max_Size2D, 'Max Size 2D')
smesh.SetName(Regular1D.GetAlgorithm(), 'Regular 1D')
smesh.SetName(Automatic_length, 'Automatic length')
#smesh.SetName(Quadratic_Mesh, 'Quadratic Mesh')
smesh.SetName(MEFISTO_2D.GetAlgorithm(), 'MEFISTO_2D')
smesh.SetName(Tetrahedron_Netgen.GetAlgorithm(), 'Tetrahedron (Netgen)')



smesh.SetName(block, 'block')
smesh.SetName(shell, 'shell')
smesh.SetName(FBbot, 'FBbot')
smesh.SetName(FBtop, 'FBtop')
smesh.SetName(Nforce, 'Nforce')


def PrintMeshInfo(constr):
     #aMesh = theMesh.GetMesh()
     print "mesh information:"
     print "Number of nodes       : ", constr.NbNodes()
     print "Number of edges       : ", constr.NbEdges()
     print "Number of faces       : ", constr.NbFaces()
     print "Number of volumes     : ", constr.NbVolumes()


def solve12(sys,rhs):
    "need to be replaced by numpy's: numpy.linalg.solve()"
    sys20 = 0.0
   #sys20 = sys[1][ 0]*sys[2][0] - sys[2][0]*sys[1][0]
    sys21 = sys[1][ 0]*sys[2][1] - sys[2][0]*sys[1][1]
    sys22 = sys[1][ 0]*sys[2][2] - sys[2][0]*sys[1][2]
    rhs2   = sys[1][ 0]*rhs[2]     - sys[2][0] *rhs[1]
    sys[2][ 0] = sys20
    sys[2][ 1] = sys21
    sys[2][ 2] = sys22
    rhs[2] = rhs2
     
    sys10 = 0.0
   #sys10 = sys[0][0]*sys[1][0] - sys[1][0]*sys[0][0]
    sys11 = sys[0][0]*sys[1][1] - sys[1][0]*sys[0][1]
    sys12 = sys[0][0]*sys[1][2] - sys[1][0]*sys[0][2]
    rhs1  = sys[0][0]*rhs[1]    - sys[1][0]*rhs[0]
    sys[1][0] = sys10
    sys[1][1] = sys11
    sys[1][2] = sys12
    rhs[1] = rhs1

    sys21 = 0.0
   #sys21 = sys[1][1]*sys[2][1] - sys[2][1]*sys[1][1]
    sys22 = sys[1][1]*sys[2][2] - sys[2][1]*sys[1][2]
    rhs2  = sys[1][1]*rhs[2]    - sys[2][1]*rhs[1]
    sys[2][1] = sys21
    sys[2][2] = sys22
    rhs[2] = rhs2
       
    eps = 1.0e-15
    if (abs(sys[2][2])>eps):
        x2 = rhs[2]/sys[2][2]
        x1 = (rhs[1]-sys[1][2]*x2)/sys[1][1]
        #x0 = (rhs[0]-.....)/sys[0][0] need not be implemented
    else:
        print "error - wrong initial vector for out-of-plane vector - sys[2,2]: ",sys[2][2]
    pass

    return x1,  x2




def node_group_near_point(mesh,refp,distance):
    dist2 = distance*distance
    node_inside_ids = []
    node_outside_ids = []
    for node_id in mesh.GetNodesId():
        x, y, z = mesh.GetNodeXYZ(node_id)
        d  = (x - refp[0])**2
        d += (y - refp[1])**2
        d += (z - refp[2])**2
        if d < dist2:
            node_inside_ids.append(node_id)
        else:
            node_outside_ids.append(node_id)
            pass
        pass
    return node_inside_ids,node_outside_ids


def node_group_near_line(mesh,p1,p2,dLq):
     "determines nodes near line through p1 and p2"
     "q is point of mesh: q = a0*mu+a1*tau1+a2*tau2"
     "mu is p2-p1 (defines line) and taui are perpendicular to mu"
     "distance d(line,q) = sqrt(ai*len(taui), i=1,2), in plane perp to line"
     "hence solve: (mu, tau1, tau2).T * a = (q-p1)"
     dist2 = dLq*dLq
     node_inside_ids = []
     node_outside_ids = []
     for node_id in mesh.GetNodesId():
         q1, q2, q3 = mesh.GetNodeXYZ(node_id)
         q = Numeric.array([q1,q2,q3])
         mu = Numeric.subtract(p2,p1)
         r = [0.345445132, 0.74654326562, -0.5290645345]
         pr = Numeric.cross_product(mu, r)
         cont = (Numeric.dot(pr, pr)==0)
         if (cont):
            print "initialisation not correct - use different values for ri "
         tau1 = Numeric.cross_product(mu, r)
         tau2 = Numeric.cross_product(tau1, mu)
         mu = Numeric.cross_product(tau2,tau1)
         len12 = Numeric.dot(tau1,tau1)
         len22 = Numeric.dot(tau2,tau2)
         A = Numeric.transpose([mu,tau1,tau2])  # hence **columns** of A are mu, tau1, tau2
         rhs = Numeric.subtract(q,p1)
         res1,res2 = solve12(A,rhs)
         L12 = len12*res1*res1
         L22 = len22*res2*res2
         dPQ2 = L12+L22
         if dPQ2 < dist2:
             node_inside_ids.append(node_id)
         else:
             node_outside_ids.append(node_id)
             pass
         pass
     pass
     return node_inside_ids,node_outside_ids

def node_group_within_block(mesh,p1,p2):
     "determines nodes within the block defined by p1 and p2"
     xmin, ymin, zmin = p1
     xmax, ymax, zmax = p2
     print p1
     print p2
     print xmin,ymin,zmin
     print xmax,ymax,zmax
     node_inblock = []
     node_outblock = []
     for node_id in mesh.GetNodesId():
         q1, q2, q3 = mesh.GetNodeXYZ(node_id)
         if ((q1>xmin) and (q1<xmax) and (q2>ymin) and (q2<ymax) and (q3>zmin) and (q3<zmax)):
             node_inblock.append(node_id)
         else:
             node_outblock.append(node_id)
             pass
         pass
     pass
     return node_inblock,node_outblock


# determine elements that have any nodes in "list_of_nodes"
def element_on_nodes(mesh,list_of_elements,list_of_nodes):
    elem_inside_ids = []
    for node_i in list_of_nodes:
        for elem_i in list_of_elements:
            if (node_i in mesh.GetElemNodes(elem_i)): 
                elem_inside_ids.append(elem_i)
    return elem_inside_ids

# determine elements that have no nodes in "list_of_nodes"
def element_exclude(all_elements,incl_elements):
    elem_excl = []
    for elem_i in all_elements:
        if elem_i in incl_elements:
            pass
        else:
            elem_excl.append(elem_i)
    return elem_excl

number_of_volumes = constr.NbVolumes()
list_of_volumes = constr.GetElementsByType(VOLUME)   #ALL, NODE, EDGE, FACE, VOLUME (enumaration)
list_of_faces = constr.GetElementsByType(FACE)   #ALL, NODE, EDGE, FACE, VOLUME (enumaration)
PrintMeshInfo(constr)


# solid node selection
if (0==0):
    b1 = Numeric.array([0.3*Bx,0.01*By,Bz-0.010])  # min block
    b2 = Numeric.array([0.7*Bx,0.99*By,Bz+0.150])  # max block
    Nsolid,Ntemp = node_group_within_block(constr,b1,b2)

    grp = constr.CreateEmptyGroup(NODE, "Nsolid")
    grp.Add(Nsolid) 


