import geompy
import math
import SALOMEDS

cylinder = geompy.MakeCylinderRH(0.5, 50)
top = geompy.CreateGroup(cylinder, geompy.ShapeType["FACE"])
geompy.UnionIDs(top, [10])
cylinder = geompy.GetMainShape(top)
bot = geompy.CreateGroup(cylinder, geompy.ShapeType["FACE"])
geompy.UnionIDs(bot, [12])
cylinder = geompy.GetMainShape(bot)
geompy.addToStudy( cylinder, "cylinder" )
geompy.addToStudyInFather(cylinder, top, "top" )
geompy.addToStudyInFather(cylinder, bot, "bot" )




import salome, SMESH
import smesh
import StdMeshers
import NETGENPlugin
Mcylinder = smesh.Mesh(cylinder)
Netgen_1D_2D_3D = Mcylinder.Tetrahedron(algo=smesh.FULL_NETGEN)
NETGEN_3D_Parameters = Netgen_1D_2D_3D.Parameters()
NETGEN_3D_Parameters.SetMaxSize( 0.25 )  # change to 0.125 to get about 60k elements
NETGEN_3D_Parameters.SetSecondOrder( 1 )
NETGEN_3D_Parameters.SetOptimize( 1 )
NETGEN_3D_Parameters.SetFineness( 2 )
isDone = Mcylinder.Compute()
top = Mcylinder.Group(top)
bot = Mcylinder.Group(bot)
smesh.SetName(Mcylinder, 'Mcylinder')
smesh.SetName(NETGEN_3D_Parameters, 'NETGEN 3D Parameters')
smesh.SetName(top,'top')
smesh.SetName(bot,'bot')



salome.sg.updateObjBrowser(0)



