import geompy
import math
import SALOMEDS

import salome, SMESH
import smesh
import StdMeshers
import NETGENPlugin


null   = geompy.MakeVertex(0.00, 0, 0)
pz1    = geompy.MakeVertex(0.00, 0, 1)
pz2    = geompy.MakeVertex(0.45, 0, 2)
pz3    = geompy.MakeVertex(0.55, 0, 3)
pz4    = geompy.MakeVertex(1.00, 0, 4)
pz5    = geompy.MakeVertex(1.00, 0, 5)

pz1    = geompy.MakeVertex(0.00, 0, 1)
pz2    = geompy.MakeVertex(0.00, 0, 2)
pz3    = geompy.MakeVertex(0.00, 0, 3)
pz4    = geompy.MakeVertex(0.00, 0, 4)
pz5    = geompy.MakeVertex(0.00, 0, 5)


vz1    = geompy.MakeVector(null, pz1)
Circle = geompy.MakeCircle(null, vz1, 2)

Curve = geompy.MakePolyline([null, pz1, pz2, pz3, pz4, pz5 ])
#Curve = geompy.MakeInterpol([null, pz1, pz2, pz3, pz4, pz5])
Pipe = geompy.MakePipe(Circle, Curve)

Surfin = geompy.CreateGroup(Pipe, geompy.ShapeType["FACE"])
geompy.UnionIDs(Surfin, [25, 20, 15, 10, 3])
Pipe = geompy.GetMainShape(Surfin)
Ctop = geompy.CreateGroup(Pipe, geompy.ShapeType["EDGE"])
geompy.UnionIDs(Ctop, [29])
Pipe = geompy.GetMainShape(Ctop)
Cbot = geompy.CreateGroup(Pipe, geompy.ShapeType["EDGE"])
geompy.UnionIDs(Cbot, [8])
Pipe = geompy.GetMainShape(Cbot)


geompy.addToStudy( null, "null" )
geompy.addToStudy( pz1, "pz1" )
geompy.addToStudy( vz1, "vz1" )
geompy.addToStudy( Circle, "Circle" )
geompy.addToStudy( Pipe, "Pipe" )
geompy.addToStudy( pz2, "pz2" )
geompy.addToStudy( pz3, "pz3" )
geompy.addToStudy( pz4, "pz4" )
geompy.addToStudy( pz5, "pz5" )
geompy.addToStudy( Curve, "Curve" )
geompy.addToStudyInFather( Pipe, Surfin, "Surfin" )
geompy.addToStudyInFather( Pipe, Ctop, "Ctop" )
geompy.addToStudyInFather( Pipe, Cbot, "Cbot" )



cylinder = smesh.Mesh(Pipe)
Netgen_1D_2D = cylinder.Triangle(algo=smesh.NETGEN)
NETGEN_2D_Parameters = Netgen_1D_2D.Parameters()
NETGEN_2D_Parameters.SetMaxSize( 0.075 )
NETGEN_2D_Parameters.SetSecondOrder( 1 )
NETGEN_2D_Parameters.SetOptimize( 1 )
NETGEN_2D_Parameters.SetFineness( 3 )
NETGEN_2D_Parameters.SetQuadAllowed( 1 )
isDone = cylinder.Compute()

Ctop = cylinder.Group(Ctop)
Cbot = cylinder.Group(Cbot)
Surfin = cylinder.Group(Surfin)

## set object names
smesh.SetName(cylinder.GetMesh(), 'cylinder')
smesh.SetName(Netgen_1D_2D.GetAlgorithm(), 'Netgen 1D-2D')
smesh.SetName(NETGEN_2D_Parameters, 'NETGEN 2D Parameters')
smesh.SetName(Ctop, 'Ctop')
smesh.SetName(Cbot, 'Cbot')
smesh.SetName(Surfin, 'Surfin')


if salome.sg.hasDesktop():
		salome.sg.updateObjBrowser(0)
























