#!/bin/bash
# J.Cugnoni, CAELINUX.COM, 2010
# script to setup automatically 'localhost' to 'localhost' ssh without password 
# usefull when using network oriented softwares locally with DHCP & variable hostnames
# procedure is described here: http://www.csua.berkeley.edu/~ranga/notes/ssh_nopass.html
#
# 
# first check if sshd is running, if not start it
if [ -z "`ps -ae | grep sshd`" ]; then
  echo "sshd is not running, starting the service..."
  gksudo --description "SSHD service needs to be started, enter super user password to continue" "/opt/caelinux/ssh-start-server.sh" 
fi 
# if ssh host keys are not setup properly, regenerate them
if [ ! -f /etc/ssh/ssh_host_dsa_key ]; then
  gksudo --description "SSH needs to be reconfigured, enter super user password to continue" "/opt/caelinux/ssh-gen-host-keys.sh"  
fi
# check is ~/.ssh directory exists, if not create it
if [ ! -d $HOME/.ssh ]; then 
  echo 'Creating .ssh directory'
  mkdir -p $HOME/.ssh;
  chmod 0700 $HOME/.ssh;
fi
# check is user's id_dsa keys exist, if not create (we do the same for rsa..)
if [ ! -f $HOME/.ssh/id_dsa ]; then
  echo 'Creating ssh id_dsa'
  ssh-keygen -t dsa -f $HOME/.ssh/id_dsa -P '' >/dev/null;
  #cat $HOME/.ssh/id_dsa.pub >> $HOME/.ssh/authorized_keys2;
  cat $HOME/.ssh/id_dsa.pub >> $HOME/.ssh/authorized_keys;
  #chmod 0600 $HOME/.ssh/authorized_keys2
  chmod 0600 $HOME/.ssh/authorized_keys
  #echo 'Host localhost' >> $HOME/.ssh/config;
  #echo '              IdentityFile ~/.ssh/id_dsa' >> $HOME/.ssh/config;  
fi
if [ ! -f $HOME/.ssh/id_rsa ]; then
  echo 'Creating ssh id_rsa'
  ssh-keygen -t rsa -f $HOME/.ssh/id_rsa -P '' >/dev/null;
  #cat $HOME/.ssh/id_rsa.pub >> $HOME/.ssh/authorized_keys2;
  cat $HOME/.ssh/id_rsa.pub >> $HOME/.ssh/authorized_keys;
  #chmod 0600 $HOME/.ssh/authorized_keys2
  chmod 0600 $HOME/.ssh/authorized_keys
  #echo 'Host localhost' >> $HOME/.ssh/config;
  #echo '              IdentityFile ~/.ssh/id_dsa' >> $HOME/.ssh/config;  
fi
# add local machine in known hosts list
## if known_hosts does not exist, create it
if [ ! -f ~/.ssh/known_hosts ]; then 
  touch ~/.ssh/known_hosts
fi
## add $HOSTNAME in known_hosts
if [ -n "`ssh-keygen -F $HOSTNAME -f ~/.ssh/known_hosts`" ];  then 
  # check if key is correct
  export HOSTDSAKEY="`ssh-keyscan -p 22 -t dsa $HOSTNAME 2>/dev/null`";
  if [ -z "`grep "$HOSTDSAKEY" ~/.ssh/known_hosts`" ]; then 
    echo "Updating known_hosts entries for host $HOSTNAME"
    ssh-keygen -R $HOSTNAME -f ~/.ssh/known_hosts
    ssh-keyscan -p 22 -t rsa,dsa $HOSTNAME >> ~/.ssh/known_hosts   
  fi
else
  echo "Adding known_hosts entries for host $HOSTNAME"
  ssh-keyscan -p 22 -t rsa,dsa $HOSTNAME >> ~/.ssh/known_hosts   
fi
## add localhost in known_hosts
if [ -n "`ssh-keygen -F localhost -f ~/.ssh/known_hosts`" ];  then 
  # check if key is correct
  export HOSTDSAKEY="`ssh-keyscan -p 22 -t dsa localhost 2>/dev/null`";
  if [ -z "`grep "$HOSTDSAKEY" ~/.ssh/known_hosts`" ]; then 
    echo "Updating known_hosts entries for localhost"
    ssh-keygen -R localhost -f ~/.ssh/known_hosts
    ssh-keyscan -p 22 -t rsa,dsa localhost >> ~/.ssh/known_hosts   
  fi
else
  echo "Adding known_hosts entries for host localhost"
  ssh-keyscan -p 22 -t rsa,dsa localhost >> ~/.ssh/known_hosts   
fi

