#!/bin/bash
# script to change important Code-Aster config settings such as hostname
# J.Cugnoni, CAELinux.com, 2010
# 
# The following files are modified:
# etc/codeaster/asrun:noeud : caelinux
# etc/codeaster/astkrc/config_serveurs:serveur : caelinux
# etc/codeaster/astkrc/config_serveurs:nom_complet : caelinux
# etc/codeaster/aster-mpihosts:caelinux slots=4
#
# It will also clear the user config file (but it keeps a backup):
# ~/.astkrc/config_serveurs

asroot="/opt/aster110"

#asroot="/tmp/aster101"

# first, find previous hostname
oldhost=`grep "^noeud" $asroot/etc/codeaster/asrun | sed "s/[ ]*noeud[ ]*:[ ]*//"`

echo "Autoconfigure Code-Aster installation"
echo " aster root:   " $asroot
echo " old hostname: " $oldhost
echo " new hostname: " $HOSTNAME


# asrun files
# etc/codeaster/asrun:noeud : caelinux
echo " processing $asroot/etc/codeaster/asrun" 
cp $asroot/etc/codeaster/asrun $asroot/etc/codeaster/asrun.old
oldstring=`grep "^[ ]*noeud" $asroot/etc/codeaster/asrun.old`
newstring="noeud : $HOSTNAME"
sed "s/$oldstring/$newstring/" $asroot/etc/codeaster/asrun.old > $asroot/etc/codeaster/asrun

# config-serveurs files
# etc/codeaster/astkrc/config_serveurs:serveur : caelinux
# etc/codeaster/astkrc/config_serveurs:nom_complet : caelinux
echo " processing $asroot/etc/codeaster/astkrc/config_serveurs"
cp $asroot/etc/codeaster/astkrc/config_serveurs $asroot/etc/codeaster/astkrc/config_serveurs.old
oldstring1=`grep "^[ ]*serveur" $asroot/etc/codeaster/astkrc/config_serveurs.old`
oldstring2=`grep "^[ ]*nom_complet" $asroot/etc/codeaster/astkrc/config_serveurs.old`
newstring1="serveur : $HOSTNAME"
newstring2="nom_complet : $HOSTNAME"
sed -e "s/$oldstring1/$newstring1/" -e "s/$oldstring2/$newstring2/" $asroot/etc/codeaster/astkrc/config_serveurs.old > $asroot/etc/codeaster/astkrc/config_serveurs

# etc/codeaster/aster-mpihosts:caelinux slots=4
echo " processing $asroot/etc/codeaster/aster-mpihosts"
cp $asroot/etc/codeaster/aster-mpihosts $asroot/etc/codeaster/aster-mpihosts.old
sed "s/$oldhost/$HOSTNAME/g" $asroot/etc/codeaster/aster-mpihosts.old > $asroot/etc/codeaster/aster-mpihosts

# ~/.astkrc/config_serveurs
if [ -f ~/.astkrc/config_serveurs ]; then
  echo " renaming ~/.astkrc/config_serveurs"
  mv ~/.astkrc/config_serveurs ~/.astkrc/config_serveurs.old
fi
