#!/usr/bin/env python
"""
OpenDoc: opens both french PDF & english HTML doc
"""

import os,os.path,sys,re

# set config variables (PDF doc=french pdfs included in Eficas/Aster, HTMLDoc=English doc)
#PDFDocPath='/opt/SALOME-MECA-2008.1-GPL/aster/outils/eficas-1.13.0/Aster/Doc'
#HTMLDocPath='/opt/caelinux/docs/CodeAsterEnDoc'
HTMLDocPath='http://www.code-aster.org/V2/doc/default/en/'
subdirs={}
subdirs['u']="man_u"
subdirs['v']="man_v"
subdirs['r']="man_r"
subdirs['d']="man_d"
PDFViewer='/usr/bin/evince'
HTMLBrowser='/usr/bin/firefox'

# open PDF & identify doc index
DocString=os.path.basename(sys.argv[1])
print 'Opening doc for ', DocString
os.system(PDFViewer + ' ' + sys.argv[1] +' & ')

DocId=re.findall("([uvrdUVRD][0123456789]).([0-9][0-9]).([0-9][0-9]).*",DocString)[0]
DocIndex=DocId[0].lower()+"."+DocId[1].lower()+"."+DocId[2].lower()
print DocIndex
DocType=DocIndex[0]

# find html file & run browser
try:
	HTMLfilepath=os.path.join(HTMLDocPath,subdirs[DocType],DocId[0].lower(),DocIndex+".pdf")
	
	os.system(HTMLBrowser + ' ' + HTMLfilepath + ' & ')

except:
	print 'Error while finding HTML document'	
