#!/usr/bin/env python
# script for automatic generation of .case file for data visulization
# from Code_Aster output in Ensight format
import sys, os, os.path
from string import *

# MAIN
helpmsg="""
-----------------------------------------------------------------------
Ensight .Case file generator for Post Processing of Code-Aster results
-----------------------------------------------------------------------
J.Cugnoni, www.caelinux.com, 12.2005

 Usage: python GenEnsightCase.py ensight_result_directory
 if ensight_result_directory is omitted, the current directory is used.
"""

# get directory path & list content
print("\n------ GenEnsightCase ------\n")
if len(sys.argv)>1:
    arg1=split(sys.argv[1])[0]
    if (count(arg1,"-h")==1) | (count(arg1,"--help")==1):
        print helpmsg
        sys.exit()
    else:        
        currentdir=arg1
else:
    currentdir=os.getcwd()
if not os.path.exists(currentdir):
    print("ERROR: Input directory does not exist, please check the input path!!\n")
    sys.exit()
list=os.listdir(currentdir)
print("Ensight result directory: %s\n" % (currentdir))

# find .geo .res1 filenames
geofile=''
prefix=''
for filen in list:
    if count(filen,".geo")>0:
        geofile=filen
for filen in list:
    if count(filen,".res")>0:
        prefix=filen.split(".")[0]
if (len(prefix)==0 | len(geofile) == 0):
    print("ERROR: Can't find .geo or .res files in processed directory, \nplease check the input path!!\n")
    sys.exit()
casefile=prefix+".case"
print("Found Geo File: %s\nGenerating Case File:%s\n" % (geofile,casefile))

# open .case file & write header
fid=open(os.path.join(currentdir,casefile),'w')
fid.write("#\n# CASE file for ENSIGHT data Visualization\n#\n\n")
fid.write("FORMAT\n\ntype: ensight\n\n")
fid.write("GEOMETRY\n\nmodel: "+geofile+"\n\n")
fid.write("VARIABLE\n\n")
# print variable defs.
for filen in list:
    if count(filen,".DEPL.")>0:
        if count(filen,".")<3:
            fid.write("vector per node: DEPL "+filen+"\n")
            print("Vector field: %s\n" % (filen))
for filen in list:
    if (count(filen,".")>2) & (count(filen,prefix)>0):        
        fid.write("scalar per node: "+filen+" "+filen+"\n")
        print("Scalar field: %s\n" % (filen))
fid.close()